function [time, concentration] = CPC_Import()

cd('E:\Google Drive\Projects\HI-SCALE SGP\Data\ARM_Data\CPC - Condensation Particle Counter - C1');

currdir = dir;
time = [];
concentration = [];

for i = 1:length(currdir)
	
	cdfcheck = ~isempty(strfind(currdir(i).name,'.cdf')) || ~isempty(strfind(currdir(i).name,'.nc'));
	if cdfcheck == 0
		continue
	end
	currfile = currdir(i).name;
	datestartidx = 16;
	year_range = datestartidx : datestartidx +3;
	month_range = datestartidx +4 : datestartidx +5;
	day_range = datestartidx +6 : datestartidx +7;
	startdate = [str2num(currfile(year_range)), str2num(currfile(month_range)), str2num(currfile(day_range)), 0, 0, 0];
	sec_time = ncread(currfile,'time');
	
	currtimemat = repmat(startdate,length(sec_time),1);
	currtimemat(:,6) = currtimemat(:,6) + sec_time;
	currtimemat = datetime(currtimemat);
	time = [time ; currtimemat];
	
	currconcentration = ncread(currfile,'concentration');
	concentration = [concentration; currconcentration];
	
	
end

concentration(concentration < 0) = NaN;

end